@extends('admin.layout.template')

@section('title','Add Role')

@section('content')

<div class="page-content">
    <div class="container-xxl">

        <form method="POST" action="{{ route('roles.store') }}">
            @csrf

            {{-- Role Info --}}
            <div class="card mb-4">
                <div class="card-header">
                    <h4>Create Role</h4>
                </div>
                <div class="card-body row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Role Name</label>
                        <input type="text" name="role_name" class="form-control" required>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">Departments</label>
                        <select name="department_ids[]" class="form-select" multiple data-choices required>
                            @foreach($departments as $dept)
                            <option value="{{ $dept->id }}">{{ $dept->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-12 mt-2">
                        <div class="form-check">
                            <input type="checkbox" name="is_locked" class="form-check-input" id="is_locked">
                            <label class="form-check-label" for="is_locked">Lock this role (System Role)</label>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Permissions --}}
            @foreach($permissions as $module => $perms)
            <div class="card mb-3 p-3">
                <div class="d-flex justify-content-between mb-2">
                    <h4 class="text-lg font-semibold text-blue-600 mb-3">{{ ucfirst($module) }}</h4>
                    <div class="form-check">
                        <input type="checkbox" class="form-check-input select-all" data-module="{{ $module }}">
                        <label class="form-check-label">Select All</label>
                    </div>
                </div>

                <div class="row fw-semibold border-bottom pb-2 mb-2">
                    <div class="col-4">Module</div>
                    <div class="col-2 text-center">Add</div>
                    <div class="col-2 text-center">View</div>
                    <div class="col-2 text-center">Update</div>
                    <div class="col-2 text-center">Delete</div>
                </div>

                @php
                $normalize = function ($value) {
                return strtolower(str_replace(['-', '.', '_'], '', $value));
                };

                $actions = ['add', 'view', 'update', 'delete'];

                $moduleAliases = [
                'user' => ['user', 'users'],
                'users' => ['user', 'users'],
                'role' => ['role', 'roles'],
                'roles' => ['role', 'roles'],
                'product' => ['product', 'products'],
                'coupon' => ['coupon', 'coupons'],
                'location' => ['location', 'locations'],
                'locations' => ['location', 'locations'],
                'stock' => ['stock'],
                'banner' => ['banner'],
                'profile' => ['profile'],
                ];
                @endphp


                <div class="row align-items-center py-2 permission-row">
                    <div class="col-4 text-capitalize fw-semibold">
                        {{ str_replace('-', ' ', $module) }}
                    </div>
                    @foreach($actions as $action)
                    @php
                    $permissionName = null;

                    $aliases = $moduleAliases[$module] ?? [$module];

                    foreach ($perms as $perm) {
                    $normalizedPerm = $normalize($perm);

                    foreach ($aliases as $alias) {
                    $normalizedAlias = $normalize($alias);

                    // VIEW
                    if ($action === 'view') {
                    if (
                    $normalizedPerm === $normalizedAlias ||
                    \Illuminate\Support\Str::endsWith($perm, '.index')
                    ) {
                    $permissionName = $perm;
                    break 2;
                    }
                    }

                    // ADD / UPDATE / DELETE
                    if (
                    str_contains($normalizedPerm, $normalize($action)) &&
                    str_contains($normalizedPerm, $normalizedAlias)
                    ) {
                    $permissionName = $perm;
                    break 2;
                    }
                    }
                    }
                    @endphp

                    <div class="col-2 text-center">
                        @if($permissionName)
                        <input type="checkbox"
                            class="form-check-input permission-checkbox module-{{ $module }}"
                            name="permissions[]"
                            value="{{ $permissionName }}">
                        @endif
                    </div>
                    @endforeach

                </div>



                {{-- Data Scope --}}
                <div class="row mt-3">
                    <div class="col-md-6">
                        <label class="form-label">Data Access Scope</label>
                        <select name="scopes[{{ $module }}][scope_type]"
                            class="form-select scope-type"
                            data-module="{{ $module }}">
                            <option value="all">All Data</option>
                            <option value="assigned_location">Assigned Locations</option>
                            <option value="assigned_franchise">Assigned Franchise</option>
                            <option value="assigned_dealer">Assigned Dealer</option>
                            <option value="own_only">Own Records Only</option>
                        </select>
                    </div>

                    {{-- Locations --}}
                    <div class="col-md-6 d-none scope-value" id="scope-assigned_location-{{ $module }}">
                        <label class="form-label">Locations</label>
                        <select name="scopes[{{ $module }}][scope_value][]" class="form-select" multiple data-choices>
                            @foreach(App\Models\Location::all() as $loc)
                            <option value="{{ $loc->id }}">{{ $loc->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    {{-- Franchise --}}
                    <div class="col-md-6 d-none scope-value" id="scope-assigned_franchise-{{ $module }}">
                        <label class="form-label">Franchise</label>
                        <select name="scopes[{{ $module }}][scope_value][]" class="form-select" multiple data-choices>
                            @foreach(App\Models\User::where('user_type','franchise')->get() as $f)
                            <option value="{{ $f->id }}">{{ $f->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    {{-- Dealer --}}
                    <div class="col-md-6 d-none scope-value" id="scope-assigned_dealer-{{ $module }}">
                        <label class="form-label">Dealer</label>
                        <select name="scopes[{{ $module }}][scope_value][]" class="form-select" multiple data-choices>
                            @foreach(App\Models\User::where('user_type','dealer')->get() as $d)
                            <option value="{{ $d->id }}">{{ $d->name }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>

            </div>
            @endforeach

            <div class="text-end mb-5">
                <button type="submit" class="btn btn-primary">Save Role</button>
            </div>
        </form>
    </div>
</div>

<script>
    // Select All permissions
    document.querySelectorAll('.select-all').forEach(el => {
        el.addEventListener('change', function() {
            document.querySelectorAll('.module-' + this.dataset.module)
                .forEach(cb => cb.checked = this.checked);
        });
    });

    // Data Scope switcher
    document.querySelectorAll('.scope-type').forEach(select => {
        select.addEventListener('change', function() {
            const module = this.dataset.module;
            const val = this.value;
            document.querySelectorAll(`[id^="scope-"][id$="-${module}"]`).forEach(el => el.classList.add('d-none'));
            if (!['all', 'own_only'].includes(val)) {
                const target = document.getElementById('scope-' + val + '-' + module);
                if (target) target.classList.remove('d-none');
            }
        });
    });
</script>

@endsection